import os
import glob
import pandas as pd
import datetime
import tkinter as tk
from tkinter import filedialog


def check_headers(file_path, assignment_number, due_date, roster):
    file_path = os.path.normpath(file_path)
    path_sep = os.sep
    details = {
        "wrong_id": "",
        "wrong_folder_name": "",
        "wrong_file_name": "",
        "wrong_header_last_name": "",
        "wrong_header_first_name": "",
        "wrong_date": "",
        "wrong_file_assignment_number": "",
        "wrong_header_assignment_number": "",
        "error_message": "",
        }
    flags = {
        "id_good": False,
        "folder_name_good": False,
        "file_name_good": False,
        "header_last_name_good": False,
        "header_first_name_good": False,
        "date_good": False,
        "file_assignment_number_good": False,
        "header_assignment_number_good": False
        }
    # datetime.datetime.now()
    with open(file_path) as f:
        lines_with_blank_lines = f.readlines()
        # remove all the blank lines
        lines = []
        marked_line_number=-1
        line_number=0
        for line in lines_with_blank_lines:
            if line.isspace():
                continue
            lines.append(line)
            # try to find the line which includes assignment number.
            # Assignment number should be in the 4th line, however there may be additional non-blank line on top of file
            if marked_line_number == -1:
                if "assignment" in line.lower():
                    marked_line_number=line_number
                line_number += 1

        try:

            student_name_from_header = lines[marked_line_number-3].strip().replace("#", "").strip()
            student_name_from_header=student_name_from_header.split(",")
            last_name_from_header=""
            first_name_from_header=""
            if len(student_name_from_header)>0:
                last_name_from_header=student_name_from_header[0].strip()
            if len(student_name_from_header)>1:
                first_name_from_header=student_name_from_header[1].strip()
            student_id_from_header=lines[marked_line_number-2].strip().replace("_", "").replace("#",
                                                                                                "").strip().split(" ")
            student_id_from_header = int(student_id_from_header[0])

            assignment_number_from_header = lines[marked_line_number].strip().replace("# ", "").split("_")

            folders, file_name = os.path.split(file_path)
            split_file_name = file_name.split("_")
            last_name_from_file_name = split_file_name[0]
            assignment_number_from_file = split_file_name[1]

        except:
            # If there are additional non-blank lines on the top of the file
            print(f"Error: can not extract information from file {file_path}")
            details["error_message"] = details[
                                           "error_message"] + "Error: can not extract information from file: " + \
                                       file_path + " ; "
            details["wrong_file_name"] = file_path
            return None, flags, details
        # look in roster dataframe for student_id in "student_id" column
        try:
            student_row = roster.loc[roster["student_id"] == student_id_from_header]
        except ValueError:
            print(f"Student ID {student_id_from_header} not found in roster file.")
            # output_df.loc[student_id_from_header,:]=""
            details["wrong_id"] = student_id_from_header
            details["error_message"] = details["error_message"] + \
                f"Exception in data frame row with student ID {student_id_from_header} in the roster file. ; "
            details["wrong_file_name"] = file_path
            return None, flags, details
        if student_row.empty:
            flags["id_good"] = False
            details["wrong_id"] = student_id_from_header
            print(f"Student ID {student_id_from_header} not found in roster file")
            details["error_message"] = details[
                                           "error_message"] + f"Student ID {student_id_from_header} not fo" \
                                                              f"und in roster file. ; "
            return None, flags, details
        else:
            flags["id_good"] = True
            # mark submitted as true in the output_df
            # output_df.loc[int(student_id_from_header), "Program Submitted"] = True
            last_name_from_roster = student_row["lastname"].values[0].strip()
            first_name_from_roster = student_row["firstname"].values[0].strip()
        # check if student name matches name in roster
        path_split = file_path.split(path_sep)
        last_name_from_folder = path_split[-2][0:len(last_name_from_roster)]
        if last_name_from_folder.lower() == last_name_from_roster.lower():
            flags["folder_name_good"] = True
        else:
            flags["folder_name_good"] = False
            details["wrong_folder_name"] = "Roster: " + last_name_from_roster.lower() + \
                                           " ; Folder: " + last_name_from_folder
            details["error_message"] = details[
                                           "error_message"] + "Last name from roster does not match last name from " \
                                                              "folder. ; "
            print(f"ERROR: folder name {details['wrong_folder_name']} is incorrect.")
        if last_name_from_file_name == last_name_from_roster:
            flags["file_name_good"] = True
        else:
            flags["file_name_good"] = False
            details["wrong_file_name"] = "Roster: " + last_name_from_roster + \
                                         " ; File Name: " + last_name_from_file_name
            details["error_message"] = details[
                                           "error_message"] + "Last name from roster does not match last name from " \
                                                              "file name. ; "
            print(f"ERROR: folder name {details['wrong_file_name']} is incorrect.")
        if last_name_from_header == last_name_from_roster:
            flags["header_last_name_good"] = True
        else:
            flags["header_last_name_good"] = False
            details["wrong_header_last_name"] = "Roster: " + last_name_from_roster + \
                                                " ; Header: " + last_name_from_header
            details["error_message"] = details[
                                           "error_message"] + "Last name from roster does not match last name from " \
                                                              "header. ; "
            print(f"ERROR: Header last name {details['wrong_header_last_name']} is incorrect.")
        if first_name_from_header == first_name_from_roster:
            flags["header_first_name_good"] = True
        else:
            flags["header_first_name_good"] = False
            details["wrong_header_first_name"] = "Roster: " + first_name_from_roster + " ; Header: " + \
                                                 first_name_from_header
            details["error_message"] = details[
                                           "error_message"] + "First name from roster does not match first name from " \
                                                              "header. ; "
            print(f"ERROR: Header first name {details['wrong_header_first_name']} is incorrect.")

        ########################################### Check Date ########################################
        # convert date to a datetime and check it

        try:
            date_obj_from_header = datetime.datetime.strptime(lines[marked_line_number-1].strip(), "# %Y_%m_%d")
            if ((due_date - date_obj_from_header).days < 28) and ((due_date - date_obj_from_header).days >= 0):
                flags["date_good"] = True
            else:
                flags["date_good"] = False
                details["wrong_date"] = lines[2].strip()
                details["error_message"] = details["error_message"] + "Date is incorrect. ; "
                print(f"ERROR: Date {details['wrong_date']} is incorrect.")

        except ValueError:
            flags["date_good"] = False
            print("Date format invalid or not a recent date")
            details["wrong_date"] = lines[2].strip().replace("# ", "")
            details["error_message"] = details["error_message"] + "Header date is incorrect. ; "

        ###########################  Check Assignment number #########################################
        # Check assignment number from Header
        if assignment_number_from_file == assignment_number:
            flags["file_assignment_number_good"] = True
        else:
            flags["file_assignment_number_good"] = False
            print(f"Assignment number from file is incorrect {file_name}")
            details["wrong_file_assignment_number"] = file_name
            details["error_message"] = details["error_message"] + "File assignment number is incorrect. ; "
        # Check assignment number from Header
        if assignment_number_from_header[0] == "Assignment" and assignment_number_from_header[1] == assignment_number:
            flags["header_assignment_number_good"] = True
        else:
            flags["header_assignment_number_good"] = False
            print(f"Assignment number from header is incorrect {lines[3]}")
            details["wrong_header_assignment_number"] = lines[3].strip().replace("# ", "")
            details["error_message"] = details["error_message"] + "Header assignment number is incorrect. ; "

    return student_id_from_header, flags, details

def adjust_flag(cell_value, flag):
    if cell_value is None:
        cell_value = flag
    else:
        cell_value = cell_value and flag
    return cell_value


def concatenate_to_a_pandas_cell(data_frame, index, col_header, string):
    if data_frame.loc[index, col_header]:
        data_frame.loc[index, col_header] = data_frame.loc[index, col_header] + " ; " + string
    else:
        data_frame.loc[index, col_header] = string


assignment_number = "00"
# due_date=datetime.datetime.now()
due_date_time_str = '2024/09/09 23:59:59'

due_date = datetime.datetime.strptime(due_date_time_str, '%Y/%m/%d %H:%M:%S')
roster = pd.read_csv("roster.csv")
roster["canvas_id"] = roster["canvas_id"].astype(int)
roster["student_id"] = roster["student_id"].astype(int)

# create a copy of the roster dataframe with the student id as the index
# and new columns "program submitted" and "Everything Correct"
new_df = roster.copy()
new_df.set_index("student_id", inplace=True)
missing_student_id = 9999999999
# new_df["Program Submitted"] = None
new_df["ID Correct"] = None
new_df["Folder Name Correct"] = None
new_df["File Name Correct"] = None
new_df["Header Last Name Correct"] = None
new_df["Header First Name Correct"] = None
new_df["Date Correct"] = None
new_df["File Assignment Number Correct"] = None
new_df["Header Assignment Number Correct"] = None
new_df["Everything Correct"] = None

new_df["Wrong ID"] = ""
new_df["Wrong Folder Name"] = ""
new_df["Wrong File Name"] = ""
new_df["Wrong Header Last Name"] = ""
new_df["Wrong Header First Name"] = ""
new_df["Wrong Date"] = ""
new_df["Wrong File Assignment Number"] = ""
new_df["Wrong Header Assignment Number"] = ""
new_df["Error"] = ""
new_df["File Name"] = ""

now = datetime.datetime.strftime(datetime.datetime.now(), "%Y_%m_%d_%H_%M_%S")
# get the target directory
root = tk.Tk()
root.withdraw()
target_directory = filedialog.askdirectory(title="Select unzipped student submission direcory")
for current_file in glob.glob(os.path.join(target_directory,"**", "*.py"),recursive=True):
    if os.path.isdir(current_file):
        continue
    if current_file.startswith("~"):
        # ignore macosx files
        continue

    student_id, flags, details = check_headers(current_file, assignment_number, due_date, roster)
    # print(student_id, all(flags), flags)
    if not student_id:
        new_df.loc[missing_student_id, :] = ""
        student_id = missing_student_id
        missing_student_id = missing_student_id - 1

    new_df.loc[int(student_id), "ID Correct"] = adjust_flag(new_df.loc[int(student_id), "ID Correct"], flags["id_good"])
    new_df.loc[int(student_id), "Folder Name Correct"] = \
        adjust_flag(new_df.loc[int(student_id), "Folder Name Correct"], flags["folder_name_good"])
    new_df.loc[int(student_id), "File Name Correct"] = \
        adjust_flag(new_df.loc[int(student_id), "File Name Correct"], flags["file_name_good"])
    new_df.loc[int(student_id), "Header Last Name Correct"] = \
        adjust_flag(new_df.loc[int(student_id), "Header Last Name Correct"], flags["header_last_name_good"])
    new_df.loc[int(student_id), "Header First Name Correct"] = adjust_flag(
        new_df.loc[int(student_id), "Header First Name Correct"], flags["header_first_name_good"])
    new_df.loc[int(student_id), "Date Correct"] = adjust_flag(new_df.loc[int(student_id), "Date Correct"],
                                                              flags["date_good"])
    new_df.loc[int(student_id), "File Assignment Number Correct"] = adjust_flag(
        new_df.loc[int(student_id), "File Assignment Number Correct"],
        flags["file_assignment_number_good"])
    new_df.loc[int(student_id), "Header Assignment Number Correct"] = adjust_flag(new_df.loc[int(student_id),
                                                                                             "Header Assignment "
                                                                                             "Number Correct"],
                                                                                  flags[
                                                                                      "header_assignment_number_good"])

    new_df.loc[int(student_id), "Everything Correct"] = adjust_flag(new_df.loc[int(student_id), "Everything Correct"],
                                                                    all(flags.values()))

    if not all(flags.values()):
        concatenate_to_a_pandas_cell(new_df, student_id, "Wrong ID", details["wrong_id"])
        concatenate_to_a_pandas_cell(new_df, student_id, "Wrong Folder Name", details["wrong_folder_name"])
        concatenate_to_a_pandas_cell(new_df, student_id, "Wrong File Name", details["wrong_file_name"])
        concatenate_to_a_pandas_cell(new_df, student_id, "Wrong Header Last Name", details["wrong_header_last_name"])
        concatenate_to_a_pandas_cell(new_df, student_id, "Wrong Header First Name", details["wrong_header_first_name"])
        concatenate_to_a_pandas_cell(new_df, student_id, "Wrong Date", details["wrong_date"])
        concatenate_to_a_pandas_cell(new_df, student_id, "Wrong File Assignment Number",
                                     details["wrong_file_assignment_number"])
        concatenate_to_a_pandas_cell(new_df, student_id, "Wrong Header Assignment Number",
                                     details["wrong_header_assignment_number"])
        concatenate_to_a_pandas_cell(new_df, student_id, "Error", details["error_message"])
        concatenate_to_a_pandas_cell(new_df, student_id, "File Name", current_file)
new_df.to_csv(os.path.join(target_directory, "header_verification-" + now + ".csv"))
